#version 430 core

layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;
layout (location = 6) in vec2 noiseCoords;

layout (location = 0) out vec2 vTexCoords;
layout (location = 1) out vec4 vPosition;
layout (location = 2) out vec2 vNoiseCoords;
layout (location = 3) out vec3 vNormal;
layout (location = 4) out vec3 vWorldPos;

uniform mat4 worldMatrix;

void main()

{
	gl_Position = vec4(position, 1.0);

	vWorldPos = (worldMatrix * vec4(position, 1.0)).xyz;

	vPosition = vec4(position, 1.0);

	vTexCoords = texCoords;
	vNoiseCoords = noiseCoords;
	vNormal = normal;
}
